package ru.yandex.travel.api.models.cpa;

import java.time.Instant;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.javamoney.moneta.Money;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class BusOrderSnapshotDto extends OrderSnapshotDto {
    private String provider;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "UTC")
    private Instant arrival;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "UTC")
    private Instant departure;
    private String routeName;
    private String busInternalStatus;
    private String busModel;
    private String carrierId;
    private String fromId;
    private String fromPartnerDescription;
    private String searchFromId;
    private String toId;
    private String toPartnerDescription;
    private String searchToId;
    private Boolean onlineRefund;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "UTC")
    private Instant finishedAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "UTC")
    private Instant paymentTs;

    private int totalTicketCount;
    private int adultPassengersCount; //', UInt64());
    private int childrenWithSeatsCount; //', UInt64(optional=True));
    private int activeTicketCount; //', UInt64(optional=True));
    private int baggageTicketsCount; //', UInt64(optional=True));
    private int requestedTicketCount; //', UInt64(optional=True));
    private int refundedTicketCount; //', UInt64(optional=True));

    private Money totalFeeAmount;
    private Money totalPartnerFeeAmount;
    private Money totalPartnerRefundFeeAmount;
    private Money totalRefundFeeAmount;
    private Money totalRefundTicketAmount;
    private Money totalTariffAmount;
    private Money totalAgencyFeeAmount;
}
