package ru.yandex.travel.api.models.cpa;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.cpa.ECpaItemState;

@RequiredArgsConstructor
public enum CpaItemState {
    NEW("NEW", ECpaItemState.IS_NEW),
    RESERVED("RESERVED", ECpaItemState.IS_RESERVED),
    CONFIRMED("CONFIRMED", ECpaItemState.IS_CONFIRMED),
    CANCELLED("CANCELLED", ECpaItemState.IS_CANCELLED),
    REFUNDED("REFUNDED", ECpaItemState.IS_REFUNDED),
    PENDING("PENDING", ECpaItemState.IS_PENDING);

    private final String value;

    private final ECpaItemState protoState;

    public final static EnumIndex<ECpaItemState, CpaItemState> BY_PROTO =
            EnumIndex.create(CpaItemState.class, eValue -> eValue.protoState);

    @JsonValue
    public String getValue() {
        return value;
    }
}
