package ru.yandex.travel.api.models.cpa;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;


@RequiredArgsConstructor
public enum CpaOrderDisplayType {
    UNKNOWN("UNKNOWN", EDisplayOrderType.DT_UNKNOWN),
    HOTEL("HOTEL", EDisplayOrderType.DT_HOTEL),
    AVIA("AVIA", EDisplayOrderType.DT_AVIA),
    TRAIN("TRAIN", EDisplayOrderType.DT_TRAIN),
    BUS("BUS", EDisplayOrderType.DT_BUS),
    SUBURBAN("SUBURBAN", EDisplayOrderType.DT_SUBURBAN);

    @Getter
    @JsonValue
    private final String value;
    private final EDisplayOrderType protoState;

    public final static EnumIndex<EDisplayOrderType, CpaOrderDisplayType> BY_PROTO =
            EnumIndex.create(CpaOrderDisplayType.class, eValue -> eValue.protoState);
}
