package ru.yandex.travel.api.models.cpa;

import com.google.common.collect.ImmutableMap;

import ru.yandex.travel.orders.cpa.ECpaOrderStatus;

public enum CpaOrderStatus {

    CONFIRMED, PENDING, CANCELLED, DELETED, UNPAID, REFUNDED, PAID;

    private static ImmutableMap<ECpaOrderStatus, CpaOrderStatus> CPA_STATUS_MAPPING;

    static {
        CPA_STATUS_MAPPING = ImmutableMap.<ECpaOrderStatus, CpaOrderStatus>builder().
                put(ECpaOrderStatus.OS_CONFIRMED, CONFIRMED)
                .put(ECpaOrderStatus.OS_PENDING, PENDING)
                .put(ECpaOrderStatus.OS_CANCELLED, CANCELLED)
                .put(ECpaOrderStatus.OS_DELETED, DELETED)
                // extended statuses
                .put(ECpaOrderStatus.OS_UNPAID, UNPAID)
                .put(ECpaOrderStatus.OS_REFUNDED, REFUNDED)
                .put(ECpaOrderStatus.OS_PAID, PAID).build();
        ;
    }

    public static CpaOrderStatus fromProto(ECpaOrderStatus eCpaOrderStatus) {
        CpaOrderStatus result = CPA_STATUS_MAPPING.get(eCpaOrderStatus);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException(String.format("Don't know how to map %s to CpaOrderStatus",
                eCpaOrderStatus));
    }

}
