package ru.yandex.travel.api.models.cpa;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.commons.proto.EServiceType;

@RequiredArgsConstructor
@Getter
public enum CpaOrderType {
    HOTEL_EXPEDIA(EOrderType.OT_HOTEL_EXPEDIA, EServiceType.PT_EXPEDIA_HOTEL),
    HOTEL_DOLPHIN(EOrderType.OT_HOTEL_EXPEDIA, EServiceType.PT_DOLPHIN_HOTEL),
    HOTEL_TRAVELLINE(EOrderType.OT_HOTEL_EXPEDIA, EServiceType.PT_TRAVELLINE_HOTEL),
    HOTEL_BRONEVIK(EOrderType.OT_HOTEL_EXPEDIA, EServiceType.PT_BRONEVIK_HOTEL),
    HOTEL_BNOVO(EOrderType.OT_HOTEL_EXPEDIA, EServiceType.PT_BNOVO_HOTEL),
    TRAIN(EOrderType.OT_TRAIN, EServiceType.PT_TRAIN),
    GENERIC(EOrderType.OT_GENERIC, EServiceType.PT_UNKNOWN),
    SUBURBAN(EOrderType.OT_GENERIC, EServiceType.PT_SUBURBAN),
    BUS(EOrderType.OT_GENERIC, EServiceType.PT_BUS),
    AVIA_AEROFLOT(EOrderType.OT_AVIA_AEROFLOT, EServiceType.PT_FLIGHT);

    private final EOrderType orderType;
    private final EServiceType serviceType;
}
