package ru.yandex.travel.api.models.cpa;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.orders.cpa.ECpaRefundReason;

public enum CpaRefundReason implements ValueBasedEnum<String> {
    USER("USER", ECpaRefundReason.RR_USER),
    OPERATOR("OPERATOR", ECpaRefundReason.RR_OPERATOR),
    SCHEDULE("SCHEDULE", ECpaRefundReason.RR_SCHEDULE);

    private static final EnumIndex<ECpaRefundReason, CpaRefundReason> BY_PROTO =
            EnumIndex.create(CpaRefundReason.class, CpaRefundReason::getProto);

    private final String value;
    private final ECpaRefundReason proto;

    CpaRefundReason(String value, ECpaRefundReason proto) {
        this.value = value;
        this.proto = proto;
    }

    public static CpaRefundReason fromProto(ECpaRefundReason proto) {
        return BY_PROTO.getByValueOrNull(proto);
    }

    @Override
    public String getValue() {
        return value;
    }

    public ECpaRefundReason getProto() {
        return proto;
    }
}
