package ru.yandex.travel.api.models.cpa;

import java.time.Instant;
import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoUtils;
import ru.yandex.travel.hotels.common.orders.promo.YandexPlusApplication;
import ru.yandex.travel.orders.cpa.TWhiteLabelCpaInfo;
import ru.yandex.travel.orders.cpa.TYandexPlusCpaInfo;
import ru.yandex.travel.white_label.proto.EWhiteLabelPointsType;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public abstract class HotelOrderSnapshotDto extends OrderSnapshotDto {
    private LocalDate checkInDate;
    private LocalDate checkOutDate;
    private String hotelName;
    private String hotelCountryName;
    private String hotelCityName;
    private String permalink;
    @JsonProperty("privetmir_oct2020_eligible")
    private boolean mir2020Eligible;
    private Money amountPayable;
    private CpaRefundReason refundReason;
    private YandexPlusCpaInfo yandexPlusCpaInfo;
    private WhiteLabelCpaInfo whiteLabelCpaInfo;

    public void setWhiteLabelCpaInfo(TWhiteLabelCpaInfo whiteLabelData) {
        this.whiteLabelCpaInfo = WhiteLabelCpaInfo.fromProto(whiteLabelData);
    }

    @Getter
    @NoArgsConstructor(access = AccessLevel.PRIVATE)
    public static class WhiteLabelCpaInfo {
        private int pointsAmount;
        private EWhiteLabelPointsType pointsType;
        private String customerNumber;

        public static WhiteLabelCpaInfo fromProto(TWhiteLabelCpaInfo proto) {
            var whiteLabel = new WhiteLabelCpaInfo();
            whiteLabel.pointsAmount = proto.getPointsAmount();
            whiteLabel.pointsType = proto.getPointsType();
            whiteLabel.customerNumber = proto.getCustomerNumber();
            return whiteLabel;
        }
    }

    public void setYandexPlusCpaInfo(TYandexPlusCpaInfo yandexPlusData) {
        this.yandexPlusCpaInfo = YandexPlusCpaInfo.fromProto(yandexPlusData);
    }

    @Getter
    @NoArgsConstructor(access = AccessLevel.PRIVATE)
    public static class YandexPlusCpaInfo {
        private YandexPlusApplication.Mode mode;
        private Integer userBalance;
        private Integer topupPoints;
        private Instant topupDate;
        private Integer withdrawPoints;

        public static YandexPlusCpaInfo fromProto(TYandexPlusCpaInfo proto) {
            var plus = new YandexPlusCpaInfo();
            if (proto.hasUserBalance()) {
                plus.userBalance = proto.getUserBalance().getValue();
            }

            switch (proto.getMode()) {
                case YPCM_TOPUP:
                    plus.mode = YandexPlusApplication.Mode.TOPUP;
                    plus.topupPoints = proto.getTopupPoints();
                    plus.topupDate = ProtoUtils.toInstant(proto.getTopupDate());
                    break;
                case YPCM_WITHDRAWAL:
                    plus.mode = YandexPlusApplication.Mode.WITHDRAW;
                    plus.withdrawPoints = proto.getWithdrawPoints();
                    break;
                default:
                    throw new IllegalArgumentException("Unknown yandex plus mode: " + proto.getMode());
            }

            return plus;
        }
    }
}
