package ru.yandex.travel.api.models.cpa;

import java.time.Instant;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.javamoney.moneta.Money;

@Data
public class OrderSnapshotDto {
    @Data
    @AllArgsConstructor
    public static class PersonalUserData {
        private String email;
        private String phone;
        private String ownerLogin;
        private String ownerPassportId;
    }

    private CpaOrderStatus orderStatus;
    private CpaItemState itemState;
    private String travelOrderId;
    private String boyOrderId;
    private String partnerOrderId;
    private String label;
    private Money amount;
    private Money profit;
    private List<String> promoCodes;
    private List<String> promoActions;
    private Money discountAmount;
    private Money promocodeDiscountAmount;
    private Money strikeThroughDiscountAmount;
    private boolean usesDeferredPayment;
    private Money amountReceivedFromUser;
    private DeferredPaymentEligibility deferredPaymentEligibility;
    private Money initialPaymentAmount;
    private Money penaltyAmountIfUnpaid;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "UTC")
    private Instant lastPaymentScheduledAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "UTC")
    private Instant fullyPaidAt;
    private PersonalUserData personalUserData;
    private boolean postPayEligible;
    private boolean postPayUsed;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "UTC")
    private Instant createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS", timezone = "UTC")
    private Instant updatedAt;
}
