package ru.yandex.travel.api.models.cpa;

import java.time.Instant;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.javamoney.moneta.Money;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class TrainOrderSnapshotDto extends OrderSnapshotDto {
    private int adultPassengersCount; //', UInt64());
    private int activeTicketCount; //', UInt64(optional=True));
    private Instant arrival; //', UInt64());
    private int banditFeeAppliedCount;
    private String banditType;
    private String requestedBanditType;
    private Long banditVersion;
    private int boughtInsuranceCount; //', UInt64());
    private int childrenWithSeatsCount; //', UInt64());
    private int childrenWithoutSeatsCount; //', UInt64());
    private String coachNumber; //', String());
    private String coachOwner; //', String());
    private String coachType; //', String());
    private Instant departure; //', UInt64());
    private Instant finishedAt; //', UInt64(optional=True));
    private String gender; //', String(optional=True));
    private boolean insuranceAutoReturn; //', Boolean());
    private String offerId;
    private String orderNumber; //', String(optional=True));
    private int partnerDataImOrderId; //', UInt64(optional=True));
    private Instant partnerDataExpireSetEr; //', UInt64(optional=True));
    private boolean partnerDataIsOnlyFullReturnPossible; //', Boolean(optional=True));
    private boolean partnerDataIsSuburban; //', Boolean(optional=True));
    private String partnerDataOperationId; //', String(optional=True));
    private String partnerDataCompartmentGender; //', String(optional=True));
    private String partnerDataProvider; //', String(optional=True));
    private int passengersCount; //', UInt64(optional=True));
    private int paymentAttempts; //', UInt64());
    private String paymentStatus; //', String(optional=True));
    private Instant paymentTs;
    private Instant paymentTrustCreatedAt; //', UInt64());
    private String paymentUid; //', String());
    private String paymentPurchaseToken; //', String());
    private boolean paymentUseDeferredClearing; //', Boolean());
    private Integer permille;
    private boolean rebooked;
    private boolean rebookingAvailable; //', Boolean());
    private int refundedTicketCount; //', UInt64());
    private int refundsCount; //', UInt64());
    private int requestedTicketCount; //', UInt64());
    private String routeInfoFromStationTitle; //', String(optional=True));
    private String routeInfoToStationTitle; //', String(optional=True));
    private String serviceClass; //', String(optional=True));
    private Integer schemeId; //', UInt64());
    private int stationFromId; //', UInt64());
    private int stationToId; //', UInt64());
    private int ticketsWithPlacesCount; //', UInt64());
    private int ticketsWithoutPlacesCount; //', UInt64());
    private Money totalFeeAmount; //', Float());
    private Money totalInsuranceAmount; //', Float());
    private Money totalInsuranceProfitAmount; //', Float());
    private Money totalPartnerFeeAmount; //', Float());
    private Money totalPartnerRefundFeeAmount; //', Float());
    private Money totalRefundFeeAmount; //', Float());
    private Money totalRefundInsuranceAmount; //', Float());
    private Money totalRefundTicketAmount; //', Float());
    private Money totalServiceAmount; //', Float());
    private Money totalTariffAmount; //', Float());
    private int totalTicketCount; //', UInt64());
    private int nonRefundableTicketsCount; //', UInt64());
    private String trainInternalStatus; //', String());
    private String trainName; //', String(optional=True));
    private String trainNumber; //', String());
    private String trainTicketNumber; //', String());
    private boolean twoStorey; //', Boolean());
    private String userIp; //', String());
    private boolean userIsMobile; //', Boolean());
    private String userPassportUid; //', String(optional=True));
    private long userRegionId; //', UInt64());
    private String userYandexUid; //', String(optional=True));
    private JsonNode labelParams;
}
