package ru.yandex.travel.api.models.hotels;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.hotels.offercache.api.EBadgeTheme;

@Data
@Builder
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Badge {
    @Data
    @Builder
    public static class Link {
        String text;
        String url;
    }

    @Data
    @Builder
    public static class AdditionalPromoInfo {
        private String title;
        private String text;
        private Link link;
    }

    @AllArgsConstructor
    @Getter
    public enum BadgeTheme implements ValueBasedEnum<String> {
        GREEN("GREEN", EBadgeTheme.BT_GREEN),
        BLUE("BLUE", EBadgeTheme.BT_BLUE),
        RED("RED", EBadgeTheme.BT_RED),
        NEUTRAL("NEUTRAL", EBadgeTheme.BT_NEUTRAL),
        YELLOW("YELLOW", EBadgeTheme.BT_YELLOW),
        BLACK("BLACK", EBadgeTheme.BT_BLACK),
        WHITE("WHITE", EBadgeTheme.BT_WHITE)
        ;

        private final String value;
        private final EBadgeTheme theme;

        private static final EnumIndex<EBadgeTheme, BadgeTheme> BY_PROTO = EnumIndex.create(BadgeTheme.class, x -> x.theme);

        public static BadgeTheme map(EBadgeTheme theme) {
            return BY_PROTO.getByValueOrNull(theme);
        }
    }

    @NotNull
    private String id;
    @NotNull
    private String text;
    private AdditionalPromoInfo additionalPromoInfo;
    private BadgeTheme theme;
}
