package ru.yandex.travel.api.models.hotels;

import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.Region;

@Data
@NoArgsConstructor
@ApiModel(value = "Блок отелей для кросс-сейла на транспортных вертикалях")
public class CrossSaleHotelsBlock {
    private Region region;

    private Price minPriceInRegion;

    private BoundingBox bboxAsString;
    private List<Coordinates> bboxAsStruct;

    private List<HotelWithOffers> hotels;

    private int totalHotelCount;

    private String regionImageUrl;
}
