package ru.yandex.travel.api.models.hotels;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.endpoints.hotels_portal.HotelSearchStats;

@Data
@NoArgsConstructor
public class GeoSearchPollingResult {
    private List<HotelWithOffers> headHotels = new ArrayList<>();
    private List<HotelWithOffers> tailHotels = new ArrayList<>();
    private boolean seenNotFinishedHotels = false;
    private boolean pollingFinished = false;
    private OfferCacheMetadata offerCacheMeta = null;
    private int geoRespFoundHotelsCount = 0;
    private int offset = 0;
    private BoundingBox bbox = null;
    private Integer actualGeoId = null;
    private Integer searchGeoId = null;
    private String context = null;
    private String pollingId = null;
    private String nextNavigToken = null;
    private String prevNavigToken = null;
    private String currentNavigToken = null;
    private Integer totalPricedHotelsCountAmongAllPages = null;
    private Integer totalHotelsCountAmongAllPages = null;
    private String selectedSortId = null;
    private Coordinates sortOrigin = null;
    private boolean hasMirFilter = false;
    private boolean topHotelSelected = false;
    private HotelSearchStats.PollingFinishReason pollingFinishReason = null;
    private Duration totalPollingTime = null;
    private Duration iterationTime = null;
    private Integer finalGeoPage = null;
    private int totalRetries = 0;
    private Boolean hasBoyOffers = null;
}
