package ru.yandex.travel.api.models.hotels;

import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.hotels.common.Permalink;

@Data
@NoArgsConstructor
@ApiModel(value = "Отель")
public class Hotel {
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Category {
        private String id;
        private String name;
    }

    @Data
    @NoArgsConstructor
    public static class MetroLine {
        private String id;
        private String name;
        private String color;
    }

    @Data
    @NoArgsConstructor
    public static class Station {
        public enum Type {
            METRO,
            OTHER,
        }

        private String id;
        private Type type;
        private String name;
        private Coordinates coordinates;
        private double distanceMeters;
        private String distanceText;
        private MetroLine metroLine;
    }

    @Data
    @NoArgsConstructor
    public static class HotelGeoFeature {
        /** Уникальный id геофичи */
        private String id;

        /** Идентификатор иконки для отрисовки */
        private String icon;

        /** Строковое представление геофичи (например, "1км от центра" или "Рядом аэропорт") */
        private String name;
    }

    /** Пермалинк */
    private Permalink permalink;
    /** Главный slug отеля. Может отсутствовать. */
    private String hotelSlug;
    /**
     * Наименование отеля.
     * @example "Артист"
     */
    private String name;
    /** Категория отеля (аналог рубрики в Справочнике). */
    private Category category;
    /** Координаты отеля */
    private Coordinates coordinates;
    /**
     * Адрес отеля.
     * @example "Ул. Добролюбова, д. 11"
     */
    private String address;
    /**
     * Количество звезд. От 1 до 5. Целое число.
     * @example 2
     */
    private Integer stars;
    /**
     * Рейтинг. От 1 до 5. Дробное число, 1 знак после запятой.
     * @example 3.4
     */
    private Double rating;

    /**
     * Заботливая галка. "Информация об организации подтверждена владельцем"
     */
    private Boolean hasVerifiedOwner;

    /** Информация о ближайших остановках транспорта */
    private List<Station> nearestStations;


    /** Общее число отзывов. */
    private int totalTextReviewCount;

    /** Общее количество фотографий. */
    private Integer totalImageCount; // may be missing for similar
    /** Фотографии.
     * Количество переданных фотографий зависит от контекста использования IHotel.
     * К примеру, для страницы отеля сразу будет указано несколько фотографий.
     * Для карты, для списка -- одна фотография. */
    private List<HotelImage> images;

    /** Основные удобства. Отображаются с иконкой и без группировки. */
    private List<Amenity> mainAmenities;
    /** Группы удобств */
    private List<AmenityGroup> amenityGroups;

    /**
     * Зелёный щит. "Предпринимаются меры безопасности"
     * Отсутствует для похожих отелей.
     */
    private Boolean hasSafetyMeasures;

    /** Список мер безопасности.
     * Отсутствуют для похожих отелей.
     * Присутствуют только в ответе ручки get_hotel_info, но не search_hotels
     */
    private List<Amenity> safetyMeasures;

    /** Название города
     * Отображается на SEO странице региона вместо информации о ближайших остановках транспорта
     * Отсутствует для загородных отелей
     * */
    private String cityName;

    /** Населённый пункт, в котором находится отель
     * Отображается на SEO странице региона вместо информации о ближайших остановках транспорта
     * @example "г. Сергиев Посад"
     * */
    private String location;

    /**
     * Приблизительное расстояние от пользователя до отеля (в метрах). Передаётся только при сортировке по расстоянию.
     */
    private Double distanceMeters;

    /**
     * Приблизительное расстояние от пользователя до отеля (в виде текста с единицей измерения). Передаётся только при сортировке по расстоянию.
     */
    private String distanceText;

    /*
     * Содержится ли отель в избранном? Null означает, что информации нет и сердечко рисовать не нужно.
     */
    private Boolean isFavorite;

    /**
     * Геофича отеля
     */
    private HotelGeoFeature geoFeature;
}
