package ru.yandex.travel.api.models.hotels;

import java.util.List;

import lombok.Data;
import lombok.RequiredArgsConstructor;

@Data
@RequiredArgsConstructor
public class HotelFilter {
    @Data
    @RequiredArgsConstructor
    public static class NumericValue {
        public enum Mode {
            less,
            greater,
            greaterOrEqual,
            lessOrEqual,
        }
        private final Mode mode;
        private final double value;
    }

    @Data
    @RequiredArgsConstructor
    public static class ListValue {
        private final List<String> values;
    }

    @Data
    @RequiredArgsConstructor
    public static class IgnoredValue {
    }

    private final String uniqueId;
    private final String featureId;
    private final String geoSearchBusinessId;
    private final NumericValue numericValue;
    private final ListValue listValue;
    private final IgnoredValue ignoredValue;
}
