package ru.yandex.travel.api.models.hotels;

import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@ApiModel(value = "Фотография отеля")
public class HotelImage {
    @Data
    @NoArgsConstructor
    public static class HotelImageModeration {
        private ModerationStatus status;
    }

    @Data
    @NoArgsConstructor
    public static class Size {
        private String size;
        private int height;
        private int width;
    }

    private String urlTemplate;
    private String id; // missing for similar
    private List<Size> sizes; // missing for similar
    private List<String> tags; // missing for similar
    private HotelImageModeration moderation; // exist for review image
}
