package ru.yandex.travel.api.models.hotels;

import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import ru.yandex.travel.hotels.common.refunds.RefundRule;
import ru.yandex.travel.hotels.common.refunds.RefundType;

@Data
@NoArgsConstructor
@ApiModel(value = "Один оффер отеля")
public class HotelOffer {
    @Data
    @NoArgsConstructor
    public static class MealType {
        // Поле id нужно не только для ответа фронту, но и для заполнения агрегатов тут: https://a.yandex-team.ru/arc_vcs/travel/api/src/main/java/ru/yandex/travel/api/endpoints/hotels_portal/HotelsPortalUtils.java?rev=7a75636dc7ea146611718cfa3f02940bfdda754e#L307
        // и также при выдаче на странице поиска тут: https://a.yandex-team.ru/review/2207010/files/2#file-0-111437234:R223
        // Поэтому при изменении его формата, нужно обновить логику построения агрегатов
        private String id;
        private String name;
    }

    @Data
    @NoArgsConstructor
    public static class CancellationInfo {
        private boolean hasFreeCancellation;
        private RefundType refundType;
        private List<RefundRule> refundRules;
    }

    @Data
    @NoArgsConstructor
    public static class DiscountInfo {
        public enum EDiscountReason {
            YANDEX_HOTEL,
            RESTRICTED_OFFER,
        }
        /* Базовая цена (до скидки) */
        private Price strikethroughPrice;
        /* Процент скидки по шкале от 0 до 100. Может отсутствовать, если скидка не выражается в процентах */
        private Double percent;
        /* Причина возникновения скидки. Может отсутствовать, если причина скидки неизвестна */
        private EDiscountReason reason;
        /* Отображать ли цену как цену со скидкой. Не отображаем, если процент слишком маленький */
        private boolean showDiscountInfo;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @SuperBuilder
    public static class OfferYandexPlusInfo {
        /* количество баллов */
        private long points;
        /* True, если баллы действительно будут начислены, False если нет */
        private boolean eligible;
    }

    private String id;
    private String name;
    private Price price;
    private String roomId;//optional
    private String operatorId;
    private String landingUrl;
    private CancellationInfo cancellationInfo;
    private MealType mealType;
    private boolean yandexOffer;
    private String token;
    private List<Badge> badges;
    private DiscountInfo discountInfo;
    private OfferYandexPlusInfo offerYandexPlusInfo;
}
