package ru.yandex.travel.api.models.hotels;

import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@ApiModel(value = "Офферы отеля")
public class HotelOffersInfo {
    public enum OfferGroupType {
        ROOMS,
        OPERATORS
    }

    public enum BannerType {
        NONE, // Баннер не нужен
        MIR_CASHBACK, // Кешбек на карту Мир по акции (HOTELS-5171)
        POSSIBLE_MIR_CASHBACK, // Если поменять даты, то может быть кешбек на карту Мир по акции (HOTELS-5171)
        WELCOME_PROMOCODE, // Промокод на первый заказ, TRAVELMARKETING-43
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @ApiModel(value = "Группа офферов отеля от одного партнёра")
    public static class HotelPartnerOffersInfo {
        private String operatorId;
        PansionAggregate pansionAggregate;
        CancellationInfoAggregate cancellationInfoAggregate;
        private HotelOffer defaultOffer;
        HotelOffer.MealType defaultOfferPansion;
        HotelOffer.CancellationInfo defaultOfferCancellationInfo;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @ApiModel(value = "Агрегированная информация об офферах")
    public static class AggregatedOfferInfo {
        private Price minPrice;
        private Price maxPrice;
        PansionAggregate pansionAggregate;
        CancellationInfoAggregate cancellationInfoAggregate;
    }

    private OfferSearchProgress offerSearchProgress;
    private Integer nextPollingRequestDelayMs;
    private BannerType bannerType;
    private HotelOffer defaultOffer;
    private AggregatedOfferInfo aggregatedOfferInfo;
    private List<HotelOffer> mainOffers;
    private List<HotelPartnerOffersInfo> partnerOffers;
    private List<PermaroomInfo> rooms;
    private Map<String, OperatorInfo> operatorById;
    private Integer offerCount; // Общее число предложений о размещении в данном отеле.
    private Integer operatorCount; // Общее число операторов, предоставляющих информацию о размещении в данном отеле
    private OfferGroupType groupBy;
}
