package ru.yandex.travel.api.models.hotels;

import java.util.List;

import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class HotelRatings {
    @Data
    @NoArgsConstructor
    public static class FeatureRating {
        /** Id. Машино-читаемая строка */
        private String id;
        /** Человеко-читаемое название. Для отрисовки. */
        private String name;
        /** Процент позитивных оценок */
        private int positivePercent;
    }

    /** Отзыв-тизер. На макете -- сверху справа, "80% гостям что-то понравилось."
     * На бекенде -- информацию брать из сниппета feature_ugc_answers. */
    private String teaser;
    /** Список оценок отеля из правой колонки макета. */
    private List<FeatureRating> featureRatings;

}
