package ru.yandex.travel.api.models.hotels;

import java.time.Instant;
import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

@Data
@NoArgsConstructor
@ApiModel(value = "Отзывы на отель - ответ")
public class HotelReviewsInfo {
    @Data
    @NoArgsConstructor
    public static class TextReview {
        @Data
        @NoArgsConstructor
        public static class Author {
            private String name;
            private String level;
            private String avatarUrl;
            private String profileUrl;
        }

        @Data
        @NoArgsConstructor
        public static class KeyPhraseMatch {
            @Data
            @NoArgsConstructor
            public static class Fragment {
                private int position;
                private int size;
            }

            private List<Fragment> fragments;
        }

        @Data
        @NoArgsConstructor
        public static class Moderation {
            private ModerationStatus status;
        }

        private String id;
        private String text;
        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
        private Instant updatedAt;
        private Author author;
        private int rating;
        private int totalLikeCount;
        private int totalDislikeCount;
        private UserReactionType userReaction;
        // Stub before remove
        private String businessComment;
        private int commentCount;
        private List<HotelImage> images;
        private KeyPhraseMatch keyPhraseMatch;
        private Moderation moderation;
        private String snippet;
    }

    @Data
    @NoArgsConstructor
    public static class KeyPhrase {
        private String name;
        private int reviewCount;
    }

    private int totalTextReviewCount;
    private List<TextReview> textReviews;
    private TextReview userTextReview;

    private int totalKeyPhraseCount;
    private List<KeyPhrase> keyPhrases;

    private boolean hasMore;
}
