package ru.yandex.travel.api.models.hotels;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.travel.api.models.hotels.interfaces.OfferSearchParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.SearchFilterParamsProvider;
import ru.yandex.travel.hotels.proto.region_pages.EGeoSearchSortType;

@Data
@AllArgsConstructor
public class RegionSearchHotelsRequestData implements OfferSearchParamsProvider, SearchFilterParamsProvider {
    private int limit;
    private int geoId;
    private String bBoxString;
    private List<String> filters;
    private EGeoSearchSortType sortType;
    private LocalDate checkinDate;
    private LocalDate checkoutDate;
    private Integer adults;
    private List<Integer> childrenAges;

    public RegionSearchHotelsRequestData() {
        this.limit = 0;
        this.geoId = 0;
        this.bBoxString = "";
        this.filters = new ArrayList<>();
        this.sortType = EGeoSearchSortType.UNRECOGNIZED;
    }

    // SearchFilterParamsProvider
    public List<String> getFilterAtoms() {
        return filters;
    }

    public Integer getFilterPriceFrom() {
        return null;
    }

    public Integer getFilterPriceTo() {
        return null;
    }
    public String getForceFiltersLayout() {
        return null;
    }
    public boolean isOnlyCurrentGeoId() {
        return false;
    }
}
