package ru.yandex.travel.api.models.hotels.breadcrumbs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import static ru.yandex.travel.api.models.hotels.breadcrumbs.BreadcrumbTypeConstants.FILTER_BREADCRUMB_TYPE;
import static ru.yandex.travel.api.models.hotels.breadcrumbs.BreadcrumbTypeConstants.GEO_REGION_BREADCRUMB_TYPE;
import static ru.yandex.travel.api.models.hotels.breadcrumbs.BreadcrumbTypeConstants.HOTEL_BREADCRUMB_TYPE;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "breadcrumbType")
@JsonSubTypes({
        @JsonSubTypes.Type(value = GeoRegionBreadcrumb.class, name = GEO_REGION_BREADCRUMB_TYPE),
        @JsonSubTypes.Type(value = FilterBreadcrumb.class, name = FILTER_BREADCRUMB_TYPE),
        @JsonSubTypes.Type(value = HotelBreadcrumb.class, name = HOTEL_BREADCRUMB_TYPE),
})
public interface Breadcrumb {
    @JsonIgnore
    BreadcrumbType getBreadcrumbType();
}
