package ru.yandex.travel.api.models.hotels.breadcrumbs;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.SuperBuilder;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.api.models.Region;

@Getter
@Setter
@Jacksonized
@SuperBuilder
// the annotation is meaningless without defined fields
//@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class GeoRegionBreadcrumb extends Region implements Breadcrumb {
    public GeoRegionBreadcrumb(Region region) {
        this.setGeoId(region.getGeoId());
        this.setType(region.getType());
        this.setLinguistics(region.getLinguistics());
        this.setSlug(region.getSlug());
    }

    @Override
    public BreadcrumbType getBreadcrumbType() {
        return BreadcrumbType.GEO_REGION_BREADCRUMB;
    }
}
