package ru.yandex.travel.api.models.hotels.converters;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import ru.yandex.travel.api.models.hotels.BoundingBox;

public class BoundingBoxSerializersModule extends SimpleModule {
    public BoundingBoxSerializersModule() {
        addSerializer(BoundingBox.class, new StdSerializer<BoundingBox>(BoundingBox.class){
            @Override
            public void serialize(BoundingBox value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(value.toString());
            }
        });
        addDeserializer(BoundingBox.class, new StdDeserializer<BoundingBox>(BoundingBox.class){
            @Override
            public BoundingBox deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                ObjectCodec oc = p.getCodec();
                JsonNode node = oc.readTree(p);
                return BoundingBox.of(node.asText());
            }
        });
    }
}
