package ru.yandex.travel.api.models.hotels.converters;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import ru.yandex.travel.hotels.common.Permalink;

public class PermalinkSerializersModule extends SimpleModule {
    public PermalinkSerializersModule() {
        addSerializer(Permalink.class, new StdSerializer<Permalink>(Permalink.class){
            @Override
            public void serialize(Permalink value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(value.toString());
            }
        });
        addDeserializer(Permalink.class, new StdDeserializer<Permalink>(Permalink.class){
            @Override
            public Permalink deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                ObjectCodec oc = p.getCodec();
                JsonNode node = oc.readTree(p);
                return Permalink.of(node.asText());
            }
        });
    }
}
