package ru.yandex.travel.api.models.hotels.interfaces;

import ru.yandex.travel.gen_logfeller_parser_pojo.annotations.LogfellerIgnore;
import ru.yandex.travel.hotels.common.Permalink;

public interface HotelIdentifierProvider {
    /**
     * Параметры идентификации одного отеля
     * Должно быть задано ровно одно поле, иначе - ошибка.
     */
    Permalink getPermalink();
    String getHotelSlug();

    @LogfellerIgnore
    default boolean isHotelIdentifierPresent() {
        return getPermalink() != null || getHotelSlug() != null;
    }
}
