package ru.yandex.travel.api.models.hotels.interfaces;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

public interface RegionIdentifierProviderValidation {
    @Documented
    @Constraint(validatedBy = Validator.class)
    @Target( { ElementType.METHOD, ElementType.FIELD, ElementType.TYPE })
    @Retention(RetentionPolicy.RUNTIME)
    @interface RegionIdentifierValid {
        String message() default "Many region identifiers (regionSlug and geoId)";
        Class<?>[] groups() default {};
        Class<? extends Payload>[] payload() default {};
    }

    class Validator implements ConstraintValidator<RegionIdentifierValid, RegionIdentifierProvider> {
        @Override
        public boolean isValid(RegionIdentifierProvider value, ConstraintValidatorContext context) {
            return Objects.isNull(value.getRegionSlug()) || Objects.isNull(value.getGeoId());
        }
    }
}
