package ru.yandex.travel.api.models.hotels.seo;

import lombok.Data;

@Data
public class HotelSchemaOrgInfo implements SchemaOrgInfo {
    // URL страницы и URL карты формируется фронтом, чтобы не нагружать бэк знанием формата урла портала/карты

    /** Имя отеля
     * https://schema.org/name
     */
    private String name;

    /** абсолютный урл картинки отеля
     * https://schema.org/image
     */
    private String image;

    /** ценовой диапозон в формате 500р. - 1000р.
     *  https://schema.org/priceRange
     */
    private String priceRange;

    /** адрес отеля
     * https://schema.org/address
     */
    private String address;

    /** Рейтинг. От 1 до 5. Дробное число, 1 знак после запятой.
     * https://schema.org/ratingValue
     */
    private Double ratingValue;

    /** Число отзывов.
     * https://schema.org/reviewCount
     */
    private int reviewCount;
}
