package ru.yandex.travel.api.models.rasp.morda_backend;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ParseContext {
    private Point to;
    private Point from;
    private Point originalTo;
    private Point originalFrom;
    private String transportType;
    private ResultError[] errors;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Double distance;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private boolean sameSuburbanZone;

    @Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Point {
        private Country country;
        private String key;
        private Region region;
        private Settlement settlement;
        private String slug;
        private String timezone;
        private String title;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String titleGenitive;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String preposition;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String popularTitle;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String shortTitle;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String titleLocative;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String titleAccusative;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String titleWithType;

        @Data
        @JsonIgnoreProperties(ignoreUnknown = true)
        public static class Settlement {
            private String slug;
            private String key;
            private String title;
        }

        @Data
        @JsonIgnoreProperties(ignoreUnknown = true)
        public static class Country {
            private String railwayTimezone;
            private String code;
            private String title;
        }

        @Data
        @JsonIgnoreProperties(ignoreUnknown = true)
        public static class Region {
            private String title;
        }
    }

    @Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ResultError {
        private String type;
        private String[] fields;
    }
}
