package ru.yandex.travel.api.models.seo.blocks;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public class PlainTextBlock implements TextChildBlock {
    @AllArgsConstructor
    public enum Style {
        BOLD("bold"),
        ITALIC("italic"),
        ;
        @JsonValue
        private final String styleName;
    }

    @Getter
    @AllArgsConstructor
    public static class Data {
        private String text;
        private List<Style> styles;
    }

    public SectionBlockType getType() {
        return SectionBlockType.PLAIN_TEXT_BLOCK;
    }

    private Data data;
}
