package ru.yandex.travel.api.models.seo.blocks;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum SectionBlockType {
    SECTION_TEXT_BLOCK("ISectionTextBlock"),
    SUB_SECTION_TEXT_BLOCK("ISubSectionTextBlock"),
    TEXT_BLOCK("ITextBlock"),
    SPOILER_BLOCK("ISpoilerBlock"),
    PRICE_TEXT_BLOCK("IPriceTextBlock"),
    PLAIN_TEXT_BLOCK("IPlainTextBlock"),
    EXTERNAL_LINK_BLOCK("IExternalLinkBlock"),
    HOTEL_LINK_BLOCK("IHotelLinkBlock"),
    REGION_LINK_BLOCK("IRegionLinkBlock"),
    SEARCH_HOTELS_LINK_BLOCK("ISearchHotelsLinkBlock"),
    GEO_LINK_GROUP_BLOCK("IGeoLinkGroupBlock"),
    ;

    @JsonValue
    private final String typeName;
}
