package ru.yandex.travel.api.models.train;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.proto.ETrainOrderAggregateErrorMessageCode;
import ru.yandex.travel.train.model.ErrorCode;

@RequiredArgsConstructor
public enum ApiErrorCode {
    TRY_LATER(ErrorCode.TRY_LATER, ETrainOrderAggregateErrorMessageCode.EMC_TRY_LATER),
    REBOOKING_FAILED(ErrorCode.REBOOKING_FAILED, ETrainOrderAggregateErrorMessageCode.EMC_REBOOKING_FAILED),
    INVALID_BONUS_CARD(ErrorCode.INVALID_BONUS_CARD, ETrainOrderAggregateErrorMessageCode.EMC_INVALID_BONUS_CARD),
    NO_PLACES(ErrorCode.NO_PLACES, ETrainOrderAggregateErrorMessageCode.EMC_NO_PLACES),
    NAME_REQUIRED_LATIN_LETTERS(ErrorCode.NAME_REQUIRED_LATIN_LETTERS,
            ETrainOrderAggregateErrorMessageCode.EMC_NAME_REQUIRED_LATIN_LETTERS),
    TARIFF_ERROR(ErrorCode.TARIFF_ERROR, ETrainOrderAggregateErrorMessageCode.EMC_TARIFF_ERROR),
    TOO_LATE(ErrorCode.TOO_LATE, ETrainOrderAggregateErrorMessageCode.EMC_TOO_LATE),
    INVALID_DOCUMENT_NUMBER(ErrorCode.INVALID_DOCUMENT_NUMBER,
            ETrainOrderAggregateErrorMessageCode.EMC_INVALID_DOCUMENT_NUMBER),
    TOO_LATE_FOR_ORDER(ErrorCode.TOO_LATE_FOR_ORDER, ETrainOrderAggregateErrorMessageCode.EMC_TOO_LATE_FOR_ORDER),
    CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE(ErrorCode.CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE,
            ETrainOrderAggregateErrorMessageCode.EMC_CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE),
    UNKNOWN_PARTNER_ERROR(ErrorCode.UNKNOWN_PARTNER_ERROR,
            ETrainOrderAggregateErrorMessageCode.EMC_UNKNOWN_PARTNER_ERROR);

    private final ErrorCode modelValue;
    private final ETrainOrderAggregateErrorMessageCode protoValue;

    public final static EnumIndex<ErrorCode, ApiErrorCode> BY_MODEL_VALUE =
            EnumIndex.create(ApiErrorCode.class, eValue -> eValue.modelValue);

    public final static EnumIndex<ETrainOrderAggregateErrorMessageCode, ApiErrorCode> BY_PROTO =
            EnumIndex.create(ApiErrorCode.class, eValue -> eValue.protoValue);
}
