package ru.yandex.travel.api.models.train;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.proto.ETrainOrderAggregateErrorMessageCode;
import ru.yandex.travel.train.model.ErrorMessageCode;

@RequiredArgsConstructor
public enum ApiErrorMessageCode {
    TRY_LATER(ErrorMessageCode.TRY_LATER, ETrainOrderAggregateErrorMessageCode.EMC_TRY_LATER),
    REBOOKING_FAILED(ErrorMessageCode.REBOOKING_FAILED, ETrainOrderAggregateErrorMessageCode.EMC_REBOOKING_FAILED),
    INVALID_BONUS_CARD(ErrorMessageCode.INVALID_BONUS_CARD, ETrainOrderAggregateErrorMessageCode.EMC_INVALID_BONUS_CARD),
    PARTNER_ERROR(ErrorMessageCode.PARTNER_ERROR, ETrainOrderAggregateErrorMessageCode.EMC_PARTNER_ERROR);

    private final ErrorMessageCode modelValue;
    private final ETrainOrderAggregateErrorMessageCode protoValue;

    public final static EnumIndex<ErrorMessageCode, ApiErrorMessageCode> BY_MODEL_VALUE =
            EnumIndex.create(ApiErrorMessageCode.class, eValue -> eValue.modelValue);

    public final static EnumIndex<ETrainOrderAggregateErrorMessageCode, ApiErrorMessageCode> BY_PROTO =
            EnumIndex.create(ApiErrorMessageCode.class, eValue -> eValue.protoValue);
}
