package ru.yandex.travel.api.models.train;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.train.model.ReservationPlaceType;

@RequiredArgsConstructor
public enum DisplayReservationPlaceType {
    FOLDING("FOLDING", "Откидное"),
    INVALIDS("INVALIDS", "Для инвалидов"),
    LOWER("LOWER", "Нижний ярус"),
    MIDDLE_TIER("MIDDLE_TIER", "Средний ярус"),
    FOR_MOTHER_WITH_CHILD("FOR_MOTHER_WITH_CHILD", "Для матери и ребенка"),
    NEAR_PASSENGERS_WITH_PETS("NEAR_PASSENGERS_WITH_PETS", "Рядом с местами для пассажиров с животными"),
    NEAR_PLAYGROUND("NEAR_PLAYGROUND", "У детской площадки"),
    NEAR_TABLE("NEAR_TABLE", "У стола"),
    NEAR_PLAYGROUND_TABLE("NEAR_PLAYGROUND_TABLE", "У стола рядом с детской площадкой"),
    CONFERENCE_ROOM("CONFERENCE_ROOM", "Переговорная"),
    NOT_NEAR_TABLE("NOT_NEAR_TABLE", "Не у стола"),
    LASTOCHKA_COMPARTMENT("LASTOCHKA_COMPARTMENT", "Отсек (купе) в поезде Ласточка"),
    UPPER_TIER("UPPER_TIER", "Верхний ярус"),
    FOR_PASSENGER_WITH_CHILDREN("FOR_PASSENGER_WITH_CHILDREN", "Для пассажира с детьми"),
    FOR_PASSENGER_WITH_PET("FOR_PASSENGER_WITH_PET", "Для пассажира с животным");


    private final String value;
    private final String translation;

    @JsonValue
    public String getValue() {
        return value;
    }

    public String getTranslation() {
        return translation;
    }

    public static final ImmutableMap<ReservationPlaceType, DisplayReservationPlaceType> RESERVATION_TYPE_MAPPING =
            ImmutableMap.<ReservationPlaceType, DisplayReservationPlaceType>builder().
                    put(ReservationPlaceType.FOLDABLE, FOLDING).
                    put(ReservationPlaceType.INVALIDS, INVALIDS).
                    put(ReservationPlaceType.LOWER, LOWER).
                    put(ReservationPlaceType.MIDDLE, MIDDLE_TIER).
                    put(ReservationPlaceType.MOTHER_AND_BABY, FOR_MOTHER_WITH_CHILD).
                    put(ReservationPlaceType.NEAR_PASSENGERS_WITH_PETS, NEAR_PASSENGERS_WITH_PETS).
                    put(ReservationPlaceType.NEAR_PLAYGROUND, NEAR_PLAYGROUND).
                    put(ReservationPlaceType.NEAR_TABLE, NEAR_TABLE).
                    put(ReservationPlaceType.NEAR_TABLE_PLAYGROUND, NEAR_PLAYGROUND_TABLE).
                    put(ReservationPlaceType.NEGOTIATIONS, CONFERENCE_ROOM).
                    put(ReservationPlaceType.NOT_NEAR_TABLE, NOT_NEAR_TABLE).
                    put(ReservationPlaceType.SEPARATE_COMPARTMENT, LASTOCHKA_COMPARTMENT).
                    put(ReservationPlaceType.UPPER, UPPER_TIER).
                    put(ReservationPlaceType.WITH_CHILD, FOR_PASSENGER_WITH_CHILDREN).
                    put(ReservationPlaceType.WITH_PETS, FOR_PASSENGER_WITH_PET).build();


    public static DisplayReservationPlaceType fromReservationPlaceType(ReservationPlaceType placeType) {
        return RESERVATION_TYPE_MAPPING.get(placeType);
    }
}

