package ru.yandex.travel.api.models.train;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.proto.ETrainOrderAggregateErrorType;
import ru.yandex.travel.train.model.ErrorCode;

@RequiredArgsConstructor
public enum ErrorType {
    PARTNER_ERROR(ETrainOrderAggregateErrorType.ET_PARTNER_ERROR),
    PROCESS_EXCEPTION_STATE(ETrainOrderAggregateErrorType.ET_PROCESS_EXCEPTION_STATE),
    REBOOKING_FAILED(ETrainOrderAggregateErrorType.ET_REBOOKING_FAILED);

    private final ETrainOrderAggregateErrorType protoValue;

    public final static EnumIndex<ETrainOrderAggregateErrorType, ErrorType> BY_PROTO =
            EnumIndex.create(ErrorType.class, eValue -> eValue.protoValue);

    public static ErrorType fromErrorMessageCode(ErrorCode code) {
        if (code == ErrorCode.REBOOKING_FAILED) {
            return ErrorType.REBOOKING_FAILED;
        }
        return PARTNER_ERROR;
    }
}
