package ru.yandex.travel.api.models.train;

import java.util.Map;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.proto.ETrainOrderInsuranceAggregateState;

@RequiredArgsConstructor
public enum InsuranceStatus {
    DISABLED(ETrainOrderInsuranceAggregateState.EIAG_DISABLED),
    NEW(ETrainOrderInsuranceAggregateState.EIAG_NEW),
    PRICED(ETrainOrderInsuranceAggregateState.EIAG_PRICED),
    PRICING_FAILED(ETrainOrderInsuranceAggregateState.EIAG_PRICING_FAILED),
    CHECKED_OUT(ETrainOrderInsuranceAggregateState.EIAG_CHECKED_OUT),
    CHECKOUT_FAILED(ETrainOrderInsuranceAggregateState.EIAG_CHECKOUT_FAILED),
    AUTO_RETURN(ETrainOrderInsuranceAggregateState.EIAG_AUTO_RETURN);

    private final ETrainOrderInsuranceAggregateState protoValue;

    public static final EnumIndex<ETrainOrderInsuranceAggregateState, InsuranceStatus> BY_PROTO =
            EnumIndex.create(InsuranceStatus.class, eValue -> eValue.protoValue);

    public static InsuranceStatus fromModelValue(ru.yandex.travel.train.model.InsuranceStatus value) {
        if (value == null) {
            return null;
        } else {
            return MODEL_MAP.get(value);
        }
    }


    private static final Map<ru.yandex.travel.train.model.InsuranceStatus, InsuranceStatus> MODEL_MAP = Map.of(
            ru.yandex.travel.train.model.InsuranceStatus.DISABLED, InsuranceStatus.DISABLED,
            ru.yandex.travel.train.model.InsuranceStatus.NEW, InsuranceStatus.NEW,
            ru.yandex.travel.train.model.InsuranceStatus.PRICED, InsuranceStatus.PRICED,
            ru.yandex.travel.train.model.InsuranceStatus.PRICING_FAILED, InsuranceStatus.PRICING_FAILED,
            ru.yandex.travel.train.model.InsuranceStatus.CHECKED_OUT, InsuranceStatus.CHECKED_OUT,
            ru.yandex.travel.train.model.InsuranceStatus.CHECKOUT_FAILED, InsuranceStatus.CHECKOUT_FAILED,
            ru.yandex.travel.train.model.InsuranceStatus.AUTO_RETURN, InsuranceStatus.AUTO_RETURN
    );
}
