package ru.yandex.travel.api.models.train;

import ru.yandex.travel.orders.proto.EOrderRefundState;

public enum RefundStatus {
    IN_PROGRESS, SUCCESS, FAIL;

    public static RefundStatus fromState(EOrderRefundState state) {
        switch (state) {
            case RS_NEW:
            case RS_WAITING_INVOICE_REFUND:
            case RS_WAITING_SERVICE_REFUND:
                return RefundStatus.IN_PROGRESS;
            case RS_REFUNDED:
                return RefundStatus.SUCCESS;
            case RS_FAILED:
                return RefundStatus.FAIL;
        }
        return null;
    }
}
