package ru.yandex.travel.api.models.train;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.train.model.TariffType;

@RequiredArgsConstructor
public enum RequestTariffType {
    FULL("full", TariffType.FULL),
    PUPIL("pupil", TariffType.PUPIL),
    BABY("baby", TariffType.BABY),
    CHILD("child", TariffType.CHILD),
    CHILD17("child_17", TariffType.CHILD17);

    private final String value;
    private final TariffType tariffType;

    @JsonCreator
    public static RequestTariffType fromString(String val) {
        // preparations for a future migration
        if (val == null || val.isEmpty()) {
            return null;
        }

        for (RequestTariffType candidate : RequestTariffType.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum RequestTariffType", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public TariffType toTariffType() {
        return tariffType;
    }
}
