package ru.yandex.travel.api.models.train;

import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.travel.train.model.CabinGenderKind;
import ru.yandex.travel.train.model.CabinPlaceDemands;
import ru.yandex.travel.train.model.CarStorey;
import ru.yandex.travel.train.model.CarType;
import ru.yandex.travel.train.model.DocumentType;
import ru.yandex.travel.train.model.ReservationPlaceType;
import ru.yandex.travel.train.model.Sex;

public class TrainOrderMaps {

    private TrainOrderMaps() {
    }

    private static <K, V> Map<V, K> reverseMap(Map<K, V> source) {
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static final Map<String, DocumentType> DOCUMENT_TYPE_FROM_STR = Map.of(
            "ПН", DocumentType.RUSSIAN_PASSPORT,
            "СР", DocumentType.BIRTH_CERTIFICATE,
            "ЗП", DocumentType.RUSSIAN_INTERNATIONAL_PASSPORT,
            "ЗЗ", DocumentType.FOREIGN_DOCUMENT,
            "ПМ", DocumentType.SAILOR_PASSPORT,
            "ВБ", DocumentType.MILITARY_CARD
    );

    public static final Map<DocumentType, String> DOCUMENT_TYPE_TO_STR = reverseMap(DOCUMENT_TYPE_FROM_STR);

    public static final Map<String, String> BONUS_CARD_TYPE_MAP = Map.of(
            "RzhdB", "RzhdBonus",
            "RzhdU", "UniversalRzhdCard"
    );

    public static final Map<String, Sex> SEX_FROM_STR = Map.of(
            "M", Sex.MALE,
            "F", Sex.FEMALE
    );

    public static final Map<Sex, String> SEX_TO_STR = reverseMap(SEX_FROM_STR);

    public static final Map<String, CarType> CAR_TYPE_FROM_STR = Map.of(
            "platzkarte", CarType.RESERVED_SEAT,
            "compartment", CarType.COMPARTMENT,
            "suite", CarType.LUXURY,
            "common", CarType.SHARED,
            "sitting", CarType.SEDENTARY,
            "soft", CarType.SOFT
    );

    public static final Map<CarType, String> CAR_TYPE_TO_STR = reverseMap(CAR_TYPE_FROM_STR);

    public static final Map<String, CabinGenderKind> CABIN_GENDER_KIND_FROM_STR = Map.of(
            "male", CabinGenderKind.MALE,
            "female", CabinGenderKind.FEMALE,
            "mixed", CabinGenderKind.MIXED
    );

    public static final Map<CabinGenderKind, String> CABIN_GENDER_KIND_TO_STR = reverseMap(CABIN_GENDER_KIND_FROM_STR);

    public static final Map<String, CabinPlaceDemands> CABIN_PLACE_DEMANDS_FROM_STR = Map.of(
            "compartment", CabinPlaceDemands.IN_ONE_CABIN,
            "section", CabinPlaceDemands.IN_ONE_CABIN,
            "nearest", CabinPlaceDemands.NO_SIDE_PLACES,
            "notSide", CabinPlaceDemands.IN_ONE_COMPARTMENT
    );

    public static final Map<Integer, CarStorey> CAR_STOREY_FROM_INT = Map.of(
            0, CarStorey.NO_VALUE,
            1, CarStorey.FIRST,
            2, CarStorey.SECOND
    );

    public static final Map<ReservationPlaceType, String> RESERVATION_PLACE_TYPE_TO_STR = Map.ofEntries(
            Map.entry(ReservationPlaceType.FOLDABLE, "FOLDING"),
            Map.entry(ReservationPlaceType.INVALIDS, "FOR_IMPAIRED_PASSENGER"),
            Map.entry(ReservationPlaceType.LOWER, "LOWER_TIER"),
            Map.entry(ReservationPlaceType.MIDDLE, "MIDDLE_TIER"),
            Map.entry(ReservationPlaceType.MOTHER_AND_BABY, "FOR_MOTHER_WITH_CHILD"),
            Map.entry(ReservationPlaceType.NEAR_PASSENGERS_WITH_PETS, "NEAR_PASSENGERS_WITH_PETS"),
            Map.entry(ReservationPlaceType.NEAR_PLAYGROUND, "NEAR_PLAYGROUND"),
            Map.entry(ReservationPlaceType.NEAR_TABLE, "NEAR_TABLE"),
            Map.entry(ReservationPlaceType.NEAR_TABLE_PLAYGROUND, "NEAR_PLAYGROUND_TABLE"),
            Map.entry(ReservationPlaceType.NEGOTIATIONS, "CONFERENCE_ROOM"),
            Map.entry(ReservationPlaceType.NOT_NEAR_TABLE, "NOT_NEAR_TABLE"),
            Map.entry(ReservationPlaceType.SEPARATE_COMPARTMENT, "LASTOCHKA_COMPARTMENT"),
            Map.entry(ReservationPlaceType.UPPER, "UPPER_TIER"),
            Map.entry(ReservationPlaceType.WITH_CHILD, "FOR_PASSENGER_WITH_CHILDREN"),
            Map.entry(ReservationPlaceType.WITH_PETS, "FOR_PASSENGER_WITH_PET")
    );

    public static final Map<ru.yandex.travel.train.model.Direction, Direction> DIRECTION_DIRECTION_MAP = Map.of(
            ru.yandex.travel.train.model.Direction.FORWARD, Direction.FORWARD,
            ru.yandex.travel.train.model.Direction.BACKWARD, Direction.BACKWARD
    );
}
