package ru.yandex.travel.api.models.train;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.proto.EGenericOrderAggregateState;
import ru.yandex.travel.orders.proto.ETrainOrderAggregateState;

@RequiredArgsConstructor
public enum TrainOrderStatus {
    NEW("NEW", null, EGenericOrderAggregateState.GOAG_NEW),
    WAITING_RESERVATION("WAITING_RESERVATION", ETrainOrderAggregateState.TOAG_WAITING_RESERVATION,
            EGenericOrderAggregateState.GOAG_WAITING_RESERVATION),
    RESERVED("RESERVED", null, EGenericOrderAggregateState.GOAG_RESERVED),
    STARTING_PAYMENT("STARTING_PAYMENT", null, EGenericOrderAggregateState.GOAG_STARTING_PAYMENT),
    WAITING_PAYMENT("WAITING_PAYMENT", ETrainOrderAggregateState.TOAG_WAITING_PAYMENT,
            EGenericOrderAggregateState.GOAG_WAITING_PAYMENT),
    WAITING_CANCELLATION("WAITING_CANCELLATION", null, EGenericOrderAggregateState.GOAG_WAITING_CANCELLATION),
    CANCELLED("CANCELLED", ETrainOrderAggregateState.TOAG_CANCELLED,
            EGenericOrderAggregateState.GOAG_CANCELLED),
    //START_PAYMENT_FAILED("START_PAYMENT_FAILED", ETrainOrderAggregateState.TOAG_START_PAYMENT_FAILED, null),
    PAYMENT_FAILED("PAYMENT_FAILED", ETrainOrderAggregateState.TOAG_PAYMENT_FAILED,
            EGenericOrderAggregateState.GOAG_PAYMENT_FAILED),
    CONFIRMATION_FAILED("CONFIRMATION_FAILED", ETrainOrderAggregateState.TOAG_CONFIRMATION_FAILED,
            null /*==EGenericOrderAggregateState.GOAG_CANCELLED*/),
    WAITING_CONFIRMATION("WAITING_CONFIRMATION", ETrainOrderAggregateState.TOAG_WAITING_CONFIRMATION,
            EGenericOrderAggregateState.GOAG_WAITING_CONFIRMATION),
    CONFIRMED("CONFIRMED", ETrainOrderAggregateState.TOAG_CONFIRMED,
            EGenericOrderAggregateState.GOAG_CONFIRMED),
    WAITING_REFUND("WAITING_REFUND", ETrainOrderAggregateState.TOAG_WAITING_REFUND,
            EGenericOrderAggregateState.GOAG_WAITING_REFUND),
    REFUNDED("REFUNDED", null, EGenericOrderAggregateState.GOAG_REFUNDED),
    IN_PROGRESS("IN_PROGRESS", ETrainOrderAggregateState.TOAG_IN_PROGRESS,
            null);

    private final String value;

    private final ETrainOrderAggregateState protoState;
    private final EGenericOrderAggregateState genericProtoState;

    public final static EnumIndex<ETrainOrderAggregateState, TrainOrderStatus> BY_PROTO =
            EnumIndex.createSelective(TrainOrderStatus.class, eValue -> Optional.ofNullable(eValue.protoState));
    public final static EnumIndex<EGenericOrderAggregateState, TrainOrderStatus> BY_PROTO_GENERIC =
            EnumIndex.createSelective(TrainOrderStatus.class, eValue -> Optional.ofNullable(eValue.genericProtoState));

    @JsonValue
    public String getValue() {
        return value;
    }
}
