package ru.yandex.travel.api.models.train;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

import ru.yandex.travel.orders.proto.EOrderRefundType;

public enum TrainRefundType {
    USER_REFUND, OFFICE_REFUND, INSURANCE_AUTO_RETURN;

    private static final Map<EOrderRefundType, TrainRefundType> protoRefundTypeMap = ImmutableMap.of(
            EOrderRefundType.RT_TRAIN_USER_REFUND, TrainRefundType.USER_REFUND,
            EOrderRefundType.RT_TRAIN_OFFICE_REFUND, TrainRefundType.OFFICE_REFUND,
            EOrderRefundType.RT_TRAIN_INSURANCE_AUTO_RETURN, TrainRefundType.INSURANCE_AUTO_RETURN
    );

    public static TrainRefundType fromProto(EOrderRefundType type) {
        return protoRefundTypeMap.get(type);
    }
}
