package ru.yandex.travel.api.models.train;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum WarningMessageCode {
    ALMOST_SIX_HOURS_TO_DEPARTURE(600),
    ELECTRONIC_REGISTRATION_ALMOST_EXPIRED(400),
    ELECTRONIC_REGISTRATION_EXPIRED(300),
    INSURANCE_AUTO_RETURN(900),
    LESS_THEN_SIX_HOURS_TO_DEPARTURE(500),
    TICKETS_TAKEN_AWAY(1000),
    TRAIN_ALMOST_LEFT_DEPARTURE_STATION(800),
    TRAIN_LEFT_DEPARTURE_STATION(700),
    FIFTEEN_MINUTES_TO_REFUND(801),
    REFUND_DISABLED_BECAUSE_LESS_THAN_ONE_HOUR_TO_DEPARTURE(701),
    TRAIN_LEFT_START_STATION(200),
    HAS_NON_REFUNDABLE_TARIFF(100);

    // warnings are sorted by severity and only the most important is shown at a given time
    private final int severity;
}
