package ru.yandex.travel.api.models.travel_orders;

import java.time.LocalDateTime;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.javamoney.moneta.Money;

import ru.yandex.avia.booking.service.commons.OrderError;
import ru.yandex.avia.booking.service.commons.OrderState;
import ru.yandex.avia.booking.service.dto.AirReservationDTO;
import ru.yandex.avia.booking.service.dto.TravellerInfoDTO;
import ru.yandex.avia.booking.service.dto.reference.ReferenceDTO;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AviaOrderListItem extends TravelOrderListItem {
    private AirReservationDTO airReservation;
    private List<TravellerInfoDTO> travellers;
    private Money price;
    private OrderState state;
    private LocalDateTime timeLimitAt;
    private OrderError errorCode;
    private ReferenceDTO reference;
}
