package ru.yandex.travel.api.models.travel_orders;

import java.time.LocalDate;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import ru.yandex.travel.api.endpoints.booking_flow.model.FulfillmentType;
import ru.yandex.travel.api.endpoints.booking_flow.model.Guest;
import ru.yandex.travel.api.endpoints.booking_flow.model.RateDto;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class HotelOrderListItem extends TravelOrderListItem {
    private String hotelName;
    private Integer numStars;
    private LocalDate checkinDate;
    private LocalDate checkoutDate;
    private List<Guest> guests;
    private FulfillmentType fulfillmentType;
    private RateDto price;
    private HotelOrderListItemPayment payment;
}
