package ru.yandex.travel.api.models.travel_orders;

import java.time.Instant;

import lombok.Builder;
import lombok.Value;
import org.javamoney.moneta.Money;

@Value
@Builder
public class HotelOrderListItemPayment {
    private boolean usesDeferredPayments;
    private Money amountPaid;
    private Next next;
    private boolean mayBeStarted;

    @Value
    @Builder
    public static class Next {
        private Money amount;
        private Instant paymentEndsAt;
        private Money penaltyIfUnpaid;
    }
}
