package ru.yandex.travel.api.models.travel_orders;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import ru.yandex.travel.api.endpoints.booking_flow.model.DisplayableOrderStatus;
import ru.yandex.travel.api.services.orders.OrderListSource;
import ru.yandex.travel.api.services.orders.OrderType;

@Data
public abstract class TravelOrderListItem {
    // can't be defined as UUID until we get rid of old (proxy) train orders
    private String id;
    private String yandexOrderId;
    private DisplayableOrderStatus status;
    private LocalDateTime servicedAt;
    private OrderType orderType;
    private boolean alreadyFulfilled;
    @JsonIgnore
    private OrderListSource source;
}
