package ru.yandex.travel.api.models.trips.orders;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import ru.yandex.travel.api.endpoints.booking_flow.model.DisplayableOrderStatus;
import ru.yandex.travel.api.services.orders.OrderListSource;
import ru.yandex.travel.api.services.orders.OrderType;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;

@Data
public class BaseOrderItem {
    // can't be defined as UUID until we get rid of old (proxy) train orders
    private String id;
    private String yandexOrderId;
    private String passportId;
    private EDisplayOrderState state;
    private DisplayableOrderStatus status;
    private LocalDateTime servicedAt;
    private OrderType orderType;
    private boolean alreadyFulfilled;
    @JsonIgnore
    private OrderListSource source;
}
