package ru.yandex.travel.api.models.trips.orders.buses;

import java.time.LocalDateTime;

import lombok.Builder;
import lombok.Data;

import ru.yandex.travel.bus.model.BusLegalEntity;
import ru.yandex.travel.bus.model.BusPartner;
import ru.yandex.travel.bus.model.BusPointInfo;

@Data
@Builder
public class Ride {
    private String rideId;
    private int supplierId;
    private BusPartner busPartner;
    private BusLegalEntity supplier;
    private String carrierCode;
    private BusLegalEntity carrier;

    private LocalDateTime localDepartureTime;
    private LocalDateTime localArrivalTime;
    private long duration;
    private BusPointInfo pointFrom;
    private BusPointInfo pointTo;
    private BusPointInfo titlePointFrom;
    private BusPointInfo titlePointTo;

    private String bus;
    private String routeName;
    private String routeNumber;

    private Integer refundedTicketsCount;

    private String downloadBlankToken;
}

