package ru.yandex.travel.api.services.avia;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import lombok.Getter;
import org.springframework.stereotype.Component;

@Component
@Getter
public class AviaBookingMeters {
    // variants
    private final Counter variantsAvailable = Counter.builder("orders.avia.variantsAvailable").register(Metrics.globalRegistry);
    private final Counter noVariantsAvailable = Counter.builder("orders.avia.noVariantsAvailable").register(Metrics.globalRegistry);
    private final Counter availabilityCheckRerun = Counter.builder("orders.avia.availabilityCheckRerun").register(Metrics.globalRegistry);
    private final Counter availabilityCheckTimeout = Counter.builder("orders.avia.availabilityCheckTimeout").register(Metrics.globalRegistry);
    private final Counter availabilityCheckOtherError = Counter.builder("orders.avia.availabilityCheckOtherError").register(Metrics.globalRegistry);
    private final Counter priceChanged = Counter.builder("orders.avia.priceChanged").register(Metrics.globalRegistry);
    private final Counter tariffChanged = Counter.builder("orders.avia.tariffChanged").register(Metrics.globalRegistry);

    // orders
    private final Counter ordersCreated = Counter.builder("orders.avia.ordersCreated").register(Metrics.globalRegistry);
}
