package ru.yandex.travel.api.services.avia;

import java.util.Map;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.env.Environment;

import ru.yandex.avia.booking.partners.gateways.BookingGateway;
import ru.yandex.travel.api.services.avia.testcontext.MockAeroflotGateway;
import ru.yandex.travel.orders.commons.proto.TAviaTestContext;

@RequiredArgsConstructor
@Slf4j
public class AviaBookingProviderResolver {
    private final Environment environment;
    private final Map<String, BookingGateway> bookingGateways;

    private BookingGateway gatewayForPartner(String partnerCode) {
        if (!bookingGateways.containsKey(partnerCode)) {
            throw new IllegalArgumentException(
                    String.format("Unknown partner code %s", partnerCode)
            );
        }
        return bookingGateways.get(partnerCode);
    }

    public BookingGateway gatewayForPartner(String partnerCode, TAviaTestContext testContext) {
        BookingGateway gateway = gatewayForPartner(partnerCode);
        if (testContext == null) {
            return gateway;
        }
        if (!environment.acceptsProfiles("prod")) {
            return new MockAeroflotGateway(gateway, testContext);
        } else {
            throw new IllegalArgumentException("Test contexts aren't allowed in prod!");
        }
    }
}
