package ru.yandex.travel.api.services.avia.api_gateway;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.commons.http.apiclient.HttpApiClientBase;
import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;

@Slf4j
public class AviaApiGatewayService extends HttpApiClientBase {
    public AviaApiGatewayService(AsyncHttpClientWrapper asyncHttpClient,
                                 AviaApiGatewayServiceProperties config) {
        super(asyncHttpClient, config, new ObjectMapper()
                .disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)
                .setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE));
    }

    public CompletableFuture<LandingRouteResponse> landingRoute(String slugFrom, String slugTo, String nationalVersion, String lang) {
        String urlPath =  "/landing/route/" + slugFrom + "/" + slugTo + "/" + nationalVersion + "/" + lang + "/";

        return sendRequest("GET",
                urlPath,
                null,
                LandingRouteResponse.class,
                "landingRoute"
        );
    }

    public CompletableFuture<Boolean> isPossibleTrip(int geoIdFrom, int geoIdTo, LocalDate date) {
        String urlPath =
                "/v1/is-possible-trip" +
                "/" + geoIdFrom +
                "/" + geoIdTo +
                "/" + date.format(DateTimeFormatter.ISO_DATE) +
                "/ru/";
        return sendRequest("GET",
                urlPath,
                null,
                IsPossibleTripResponse.class,
                "isPossibleTrip"
        ).thenApply(response -> response != null && response.getIsPossibleTrip());
    }
}
